<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

require_once 'xml_document.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Ccd extends XML_document{
	protected $xpath_namespaces = array('x' => 'urn:hl7-org:v3');

	protected $values_to_parse = array( 'patient_icn' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:id[@root="2.16.840.1.113883.4.349"]',
															   'attribute' => 'extension',
															   'single_value' => true),
										'title' => array( 'xpath_query' => 'x:code[@codeSystem="2.16.840.1.113883.6.1"]', 
														  'attribute' => 'displayName',
														  'single_value' => true,
														  'default_value' => 'Clinical Document'),
										'given_names' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:patient/x:name[@use="L"]/x:given'),
										'family_name' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:patient/x:name[@use="L"]/x:family',
															   'single_value' => true),
										'organization' => array('xpath_query' => 'x:author/x:assignedAuthor/x:representedOrganization/x:name', 'single_value' => true));
										

	var $schema;
	var $patient;
	var $org;

	/** 
	* How we'll describe this document throughout webmail
	*/
	function description(){
		$patient_name = $this->patient_name();
		$organization = $this->organization;
		
		$description = $this->title('Clinical Document');
		if(!empty($patient_name)) $description .= ' for '.$patient_name;
		if(!empty($organization)){
			$description .= ' from '.$organization;
			$description = strip_from_beginning($organization, $description); //Title sometimes starts with the organization - we don't need the redundancy
		}
		
		return $description;
	}

	function title(){
		if(!array_key_exists('title', $this->_values)){
			$this->_values['title'] = $this->raw_value('title');
			if(empty($this->raw_value('title'))) $this->_values['title'] = $this->value_for_tag('x:title');
			if(empty($this->raw_value('title'))) $this->_values['title'] = 'Clinical Document';
		}
		return $this->_values['title'];
	}
	
	function patient_name($default_value = NULL){
		$display_name = implode_nonempty(' ', array(implode_nonempty(' ', $this->given_names), $this->family_name));	
		if(empty($display_name) && !is_null($default_value)) return $default_value;
		return $display_name;
	}

	public static function string_matches_schema($xml_string){
		if(empty($xml_string) || !get_instance()->is->xml_string($xml_string)) return false;
	
		$xml = new DOMDocument; 
		$xml->loadXml($xml_string);
		
		$schema = $xml->documentElement->getAttribute('xsi:schemaLocation');
		#todo - copied this off of someone else's check, but I think we should be able to do a better check - surely 'v3 CDA' is pretty common in schemas		
		return (string_contains('cdar2c32', $schema) || string_contains('v3 CDA', $schema));
	}

	public static function transform_document($body){
		$xml = new DOMDocument; //load xml
		$xml->loadXml($body);
		//get schema to check if its a c32
		$schema = $xml->documentElement->getAttribute('xsi:schemaLocation');
		if(strpos($schema,'cdar2c32') !== FALSE || strpos($schema,'v3 CDA') !== FALSE) {
			$xsl_location = APPPATH.'views/xsl/cda2detail.xsl'; 
		}
		else if(isset($xml->documentElement->namespaceURI) && $xml->documentElement->namespaceURI === "urn:astm-org:CCR"){
			$xsl_location = APPPATH.'views/xsl/CCR.xsl'; 
		}
		if(isset($xsl_location)){
			$xsl_string = file_get_contents($xsl_location);
			$xsl = new DOMDocument; //load xsl
			$xsl->loadXml($xsl_string);
			$proc = new XSLTProcessor;
			$proc->importStyleSheet($xsl); // attach the xsl rules
			return $proc->transformToXML($xml);
		}
		return false;
	}
	
}
?>